<?php

namespace App\Controller;

use App\Entity\SqrGeneratedKey;
use App\Form\SqrGeneratedKeyType;
use App\Repository\SqrGeneratedKeyRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

define('METHOD', 'DES-EDE3-OFB');

/**
 * @Route("/sqr/generated/key")
 */
class SqrGeneratedKeyController extends AbstractController
{
    /**
     * @Route("/", name="app_sqr_generated_key_index", methods={"GET"})
     */
    public function index(SqrGeneratedKeyRepository $sqrGeneratedKeyRepository): Response
    {
        return $this->render('sqr_generated_key/index.html.twig', [
            'sqr_generated_keys' => $sqrGeneratedKeyRepository->findAll(),
        ]);
    }

    /**
     * @Route("/new", name="app_sqr_generated_key_new", methods={"GET", "POST"})
     */
    public function new(Request $request, SqrGeneratedKeyRepository $sqrGeneratedKeyRepository): Response
    {
        $sqrGeneratedKey = new SqrGeneratedKey();
        $form = $this->createForm(SqrGeneratedKeyType::class, $sqrGeneratedKey);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $sqrGeneratedKeyRepository->add($sqrGeneratedKey, true);

            return $this->redirectToRoute('app_sqr_generated_key_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('sqr_generated_key/new.html.twig', [
            'sqr_generated_key' => $sqrGeneratedKey,
            'form' => $form,
        ]);
    }

    /**
     * @Route("/{id}", name="app_sqr_generated_key_show", methods={"GET"})
     */
    public function show(SqrGeneratedKey $sqrGeneratedKey): Response
    {
        return $this->render('sqr_generated_key/show.html.twig', [
            'sqr_generated_key' => $sqrGeneratedKey,
        ]);
    }

    /**
     * @Route("/{id}/edit", name="app_sqr_generated_key_edit", methods={"GET", "POST"})
     */
    public function edit(Request $request, SqrGeneratedKey $sqrGeneratedKey, SqrGeneratedKeyRepository $sqrGeneratedKeyRepository): Response
    {
        $form = $this->createForm(SqrGeneratedKeyType::class, $sqrGeneratedKey);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $sqrGeneratedKeyRepository->add($sqrGeneratedKey, true);

            return $this->redirectToRoute('app_sqr_generated_key_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('sqr_generated_key/edit.html.twig', [
            'sqr_generated_key' => $sqrGeneratedKey,
            'form' => $form,
        ]);
    }

    /**
     * @Route("/{id}", name="app_sqr_generated_key_delete", methods={"POST"})
     */
    public function delete(Request $request, SqrGeneratedKey $sqrGeneratedKey, SqrGeneratedKeyRepository $sqrGeneratedKeyRepository): Response
    {
        if ($this->isCsrfTokenValid('delete'.$sqrGeneratedKey->getId(), $request->request->get('_token'))) {
            $sqrGeneratedKeyRepository->remove($sqrGeneratedKey, true);
        }

        return $this->redirectToRoute('app_sqr_generated_key_index', [], Response::HTTP_SEE_OTHER);
    }
}
